# -*- coding: UTF-8 -*-
import os
from java.io import File
from common.util import util, log
from common.constants import COMLOG9000PATH, HARDWARE_LOG_FILE
from common.constants import COMSCRIPTFILE, COMRESULTFILE
from download import DownByThread, WaitAndDownByThread, download_file_info


def collect(devObj):
    log.debug(devObj, "start collect hardware log")

    try:
        devObj["collectLocalFileName"] = HARDWARE_LOG_FILE
        devObj["collecRemotePath"] = COMLOG9000PATH
        isSuccess, errMsg = doCollect(devObj)
    except Exception as err:
        devObj["py_detail"] = 'collect hardware log script execute Error.'
        log.error(devObj, "catch except when collect hardware log,info:%s"
                  % str(err).encode("utf-8"))
        return (False, "")
    finally:
        try:
            ssh = devObj.get("SSH")
            ssh.execCmd("rm -f " + COMLOG9000PATH)
            ssh.execCmd("rm -f /home/omuser/orderListTemp.ini")
        except Exception as err:
            log.error(devObj, "catch except when delete hardware file,info:%s"
                      % str(err).encode("utf-8"))
    return isSuccess, errMsg


def doCollect(devObj):
    '''
    @devObj: Java传递给Python脚本的上下文。
    @summary:执行磁盘日志收集
    @return: boolean, string  (收集成功, _)
    '''
    colltype = "Hardware"
    # 防止设备踢session
    util.execCmdWithTimout(devObj, "TMOUT=0", 20)
    inputdict = devObj.get("SettingInfo")
    nodeid = ""

    if inputdict:
        nodeid = inputdict.get("nodeid")
    if not nodeid:
        nodeid = "null"

    # 更新配置文件
    cmd = "rm -f /home/omuser/orderListTemp.ini"
    util.execCmdWithTimout(devObj, cmd, 20)

    tempPath = os.path.dirname(__file__)
    tempFile = "orderListTemp.ini"
    filePath = str(tempPath) + "\\" + str(tempFile)
    desPath = "/home/omuser"

    fileHandle = open(filePath, 'w')
    fileHandle.write("[startTime]=null\n")
    fileHandle.write("[endTime]=null\n")
    fileHandle.write("[nodeID]=" + str(nodeid) + "\n")
    fileHandle.write("[mode]=Hardware")
    fileHandle.close()

    try:
        sftp = devObj.get("SFTP")
        sftp.putFile(File(filePath), desPath, None)
    except Exception as err:
        errInfo = str(err).encode("utf-8")
        log.error(devObj, "put file orderListTemp.ini failed:%s" % errInfo)
        devObj["py_detail"] = errInfo
        return (False, "")

    # 新老接口区分
    devNode = devObj.get("devNode")
    version = devNode.getProductVersion()
    isOldVersion = True
    isOldVersion = util.IsOldVersion(version)

    # 收集硬件日志
    collRate = 80
    if isOldVersion:
        cmd = 'sudo %s "null" "null" %s Hardware > %s &' \
              % (COMSCRIPTFILE, nodeid, COMRESULTFILE)
    else:
        cmd = 'sudo %s "%s" &' % (COMSCRIPTFILE, colltype)
    strRet = util.ExecCollectAsyn(devObj, cmd)
    collRate = WaitAndDownByThread(devObj)
    strRet = util.GetCollectResult(devObj)

    # 删除临时文件
    if os.path.exists(filePath):
        os.remove(filePath)

    # 检查收集结果
    isSuccess, retInfo = util.GetMessageInfo(devObj, strRet)
    if not isSuccess:
        log.error(devObj, "collect hardware log failed, ret=%s" % strRet)
        return (False, "")

    # 执行下载任务
    file_info = download_file_info()
    file_info.remoteFileName = devObj.get("collecRemotePath")
    file_info.localFileName = os.path.join(devObj.get("collectRetDir"),
                                           devObj.get("collectLocalFileName"))
    isSuccess, retInfo = DownByThread(devObj, collRate, 100, file_info)
    if not isSuccess:
        log.error(devObj, "download hardware failed, ret=%s" % retInfo)

    return (isSuccess, retInfo)
